/*The SAS program HEI2020 Simple Scoring Algorithm (Per Day) using NHANES 2017-2018 data and FPED */

/*  NOTE: Analysts should consider whether they want to include or exclude nutritional supplements at the food item level
 and this example does not contain code to remove those items.  */

/*INSTRUCTIONS - complete tasks 1-4 in this section, and run these SAS codes before proceeding to the HEI-2020 scoring program that follows*/

/*1.	Create a folder on your computer "home folder", and save the FPED data, NHANES data, Demographic data, and the required HEI-2020 macro in it. Specify the path to the folder. */

%let home = C:\Users\Documents\FPED_NHANES; /*In this Example, the "home" folder is in C Drive, within Documents, and is called FPED_NHANES. */


/*2.	Libnames here specify the input files. */


libname NH "&home\NH";  
libname FPED "&home\FPED"; 

/*In this Example, the FPED data are in a folder called "FPED", and the NHANES and Demographic data are in a folder called "NH", all saved within the "home" folder. These are SAS datasets. */


/*3.	Create a folder in the "Home" folder, where the output file, containing HEI-2020 component and total scores for each respondent, for the intake day, are to be exported. Specify the name of the folder. */

filename RES "&home\RES\hei2020r.csv"; 

/*In this Example, the folder is called "RES", within the "home" folder, and the exported results will be a csv file called "hei2020r". */


/*4.	Read in required HEI-2020 scoring macro. This macro must be saved within the home folder. */

%include "&home\hei2020.score.macro.sas";



/*NOTE: Once you have completed all the steps above, all you need to do is run the SAS program below. Unless you used different names for your datasets and folders, 
no other action is required from you. */


      
title 'HEI-2020 scores for NHANES 2017-2018 day 1, AGE >= 2, RELIABLE DIETS, Include Pregnant and Lactating Women';

/*Step 1: Reads in the required datasets and variables and makes necessary edits to the datasets. */

*part a: get FPED data per day;
data FPED;
 set FPED.fped_dr1tot_1718;
run;


*part b: get individual total nutrient intake if reliable recall status;
data NUTRIENT (keep=SEQN WTDRD1 DR1TKCAL DR1TSFAT DR1TALCO DR1TSODI DR1DRSTZ DR1TMFAT DR1TPFAT);
  set NH.DR1TOT_J;
  if DR1DRSTZ=1; /*reliable dietary recall status*/
run;

*part c: get demographic data for persons aged two and older;
data DEMO (keep=SEQN RIDAGEYR RIAGENDR SDDSRVYR SDMVPSU SDMVSTRA);
  set NH.DEMO_J;
  if RIDAGEYR >= 2;
run;


/*Step 2: Combines the FPED, NHANES Nutrients, and Demographic datasets to create the COHORT dataset.*/

proc sort data=FPED;
  by SEQN;
run;

proc sort data=NUTRIENT;
  by SEQN;
run;

proc sort data=DEMO;
  by SEQN;
run;

data COHORT;
  merge NUTRIENT (in=N) DEMO (in=D) FPED;
  by SEQN;
  if N and D;
run;


/*Step 3: Creates additional required variables: FWHOLEFRT, MONOPOLY, PFALLPROTLEG, PFSEAPLANTLEG, VTOTALLEG, and VDRKGRLEG. */


data COHORT;
  set COHORT;
  by SEQN;

  FWHOLEFRT=DR1T_F_CITMLB+DR1T_F_OTHER;

  MONOPOLY=DR1TMFAT+DR1TPFAT;

  VTOTALLEG=DR1T_V_TOTAL+DR1T_V_LEGUMES;
  VDRKGRLEG=DR1T_V_DRKGR+DR1T_V_LEGUMES;

  PFALLPROTLEG=DR1T_PF_MPS_TOTAL+DR1T_PF_EGGS+DR1T_PF_NUTSDS+DR1T_PF_SOY+DR1T_PF_LEGUMES; 
  PFSEAPLANTLEG=DR1T_PF_SEAFD_HI+DR1T_PF_SEAFD_LOW+DR1T_PF_NUTSDS+DR1T_PF_SOY+DR1T_PF_LEGUMES;
run;


/*Step 4: Runs the HEI-2020 scoring macro which calculates intake density amounts and HEI total and component scores. */

%HEI2020 (indat= COHORT, 
          kcal= DR1TKCAL, 
	  vtotalleg= VTOTALLEG, 
	  vdrkgrleg= VDRKGRLEG, 
	  f_total= DR1T_F_TOTAL, 
	  fwholefrt= FWHOLEFRT, 
	  g_whole= DR1T_G_WHOLE, 
	  d_total= DR1T_D_TOTAL, 
          pfallprotleg= PFALLPROTLEG, 
	  pfseaplantleg= PFSEAPLANTLEG, 
	  monopoly= MONOPOLY, 
	  satfat= DR1TSFAT, 
	  sodium= DR1TSODI, 
	  g_refined= DR1T_G_REFINED, 
	  add_sugars= DR1T_ADD_SUGARS, 
	  outdat= HEI2020); 


/*Step 5: Displays and saves the results to the specified output folder (see notes in the provided SAS program).  */ 

*part a: this program saves one HEI-2020 score for each individual, based on one 24HR;


data HEI2020R (keep=SEQN DR1TKCAL HEI2020C1_TOTALVEG HEI2020C2_GREEN_AND_BEAN HEI2020C3_TOTALFRUIT HEI2020C4_WHOLEFRUIT 
      HEI2020C5_WHOLEGRAIN HEI2020C6_TOTALDAIRY HEI2020C7_TOTPROT HEI2020C8_SEAPLANT_PROT HEI2020C9_FATTYACID HEI2020C10_SODIUM
      HEI2020C11_REFINEDGRAIN HEI2020C12_SFAT HEI2020C13_ADDSUG HEI2020_TOTAL_SCORE); 
  set HEI2020; 
  run; 
 
*part b: calculates an unweighted mean across all individuals in group; 
 
proc means n nmiss min max mean data=HEI2020R; 
run; 
 
 
*part c: saves results as CSV file one line per day; 
 
proc export data=HEI2020R 
  file=RES 
  dbms=csv 
  replace; 
run; 
 
 
 
 
 

